function [sumdata] = join_sumfiles(varargin)
%This function allows you to join summary files across WT/KO created by
%sum_collate, allows easy placement into spreadsheets, etc.
%Synatax:   [sumdata] = join_sumfiles('path1','c:\...','file1','syn.csv','mode',1)
%Input:     'path1' = the directory where the files are
%           'file1' = summary file 1
%           'path2' =  the directory of the second file.
%           'file2' = summary file 2
%           'label' = text label to stick to the front of the output file,
%               default = [];
%           'output_path' = the directory to save out, default = path1
%           'output_file' = the name of the output file, default =
%           [file1+file2];
%           'spacernum' = number of blank rows between data, default = 1
%           'mode' = either interleave mode (Default = 1) only mode
%               currently.
%Output:    sumdata = the joined summary file.

[path1,file1,path2,file2,outpath,filename_out,labeltxt,spacernum,md] = parse(varargin);  %parse the input

%open the first file
fid = fopen([path1,filesep,file1]);  %open the file
data_raw = textscan(fid,'%s %s %s %s %s %s %s','Delimiter',',');   %grab the raw text data: for WT/KO data
%data_raw = textscan(fid,'%s %s %s %s %s %s %s %s %s','Delimiter',',');   %grab the raw text data: for Fenobam data
file1_tmp = [];  %initiate
for j = 1:size(data_raw,2)      %combine the raw data into a single file
    file1_tmp = horzcat(file1_tmp,data_raw{1,j});
end
fclose(fid);

%open the second file
fid2 = fopen([path2,filesep,file2]);  %open the file
data_raw2 = textscan(fid2,'%s %s %s %s %s %s %s','Delimiter',',');   %grab the raw text data: for WT/KO data
file2_tmp = [];  %initiate
for j = 1:size(data_raw2,2)      %combine the raw data into a single file
    file2_tmp = horzcat(file2_tmp,data_raw2{1,j});
end
fclose(fid2);

if spacernum~=0
    fill_data = cell(size(file1_tmp));  %create the filler array
end

%now combine the files
switch md
    otherwise   %interleaved
        sumdata = [];
        for k = 1:size(file1_tmp,1)
            if spacernum~=0
                for l = 1:spacernum
                    sumdata = vertcat(sumdata,fill_data(k,:));
                end
            end
            sumdata = vertcat(sumdata,file1_tmp(k,:));
            sumdata = vertcat(sumdata,file2_tmp(k,:));
            if spacernum~=0
                for l = 1:spacernum
                    sumdata = vertcat(sumdata,fill_data(k,:));
                end
            end
        end
end

%save out the file
sav2csv(sumdata,[labeltxt,filename_out],outpath);

%--------------------------------------------------------------------------
%subfunction to parse the inputs.
function [path1,file1,path2,file2,outpath,filename_out,labeltxt,spacernum,md] = parse(input)

path1 = [];
file1 = [];
path2 = [];
file2 = [];
outpath = [];
labeltxt = [];
spacernum = 1;
filename_out = [];
md = 1;

%Parse the input
if ~isempty(input)
    for i = 1:2:size(input,2)
        if ischar(input{1,i});
            switch input{1,i}
                case 'path1'
                    path1 = input{1,i+1};
                case 'file1'
                    file1 = input{1,i+1};
                case 'path2'
                    path2 = input{1,i+1};
                case 'file2'
                    file2 = input{1,i+1};
                case 'output_file'
                    filename_out = input{1,i+1};
                case 'output_path'
                    outpath = input{1,i+1};
                case 'label'
                    labeltxt = input{1,i+1};
                case 'spacernum'
                    spacernum = input{1,i+1};
                case 'mode'
                    md = input{1,i+1};
                otherwise
                    warning(['Your input ',input{1,i},' is not recognized.']);
            end
        else
            error(['The parameters you entered is incorrect.  Please check help.']);
        end
    end
end

if isempty(path1)||isempty(file1)   %get files and directory
    [file1,path1,filterindex] = uigetfile2({'*.csv','Text files (*.csv)';'*.*','All Files';},...
        'Open Summary file1','Multiselect','off');
end
if isempty(path2)||isempty(file2)   %get files and directory
    [file2,path2,filterindex] = uigetfile2b({'*.csv','Text files (*.csv)';'*.*','All Files';},...
        'Open Summary file1','Multiselect','off');
end
if isempty(outpath)
    outpath = path1;
end
if isempty(filename_out)
    filename_out = [file1,'+',file2];
end